package ru.yandex.util.ip;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.collection.BinaryTrieSet;
import ru.yandex.collection.ByteArrayBitIterator;

public enum CidrSet implements IpSet<Map<Integer, BinaryTrieSet>> {
    INSTANCE;

    @Override
    public Builder<Map<Integer, BinaryTrieSet>> createBuilder() {
        return new CidrSetBuilder();
    }

    @Override
    public boolean contains(
        final Map<Integer, BinaryTrieSet> cidrs,
        final InetAddress ip)
    {
        byte[] addr = ip.getAddress();
        BinaryTrieSet trie = cidrs.get(addr.length);
        return trie != null
            && trie.containsPrefix(new ByteArrayBitIterator(addr));
    }

    private static class CidrSetBuilder
        implements Builder<Map<Integer, BinaryTrieSet>>
    {
        private final Map<Integer, BinaryTrieSet> cidrs = new HashMap<>();

        @Override
        public void add(final String ip) throws IOException {
            Cidr cidr = Cidr.fromString(ip);
            cidrs.computeIfAbsent(cidr.addrLen(), x -> new BinaryTrieSet())
                .add(cidr.iterator());
        }

        @Override
        public Map<Integer, BinaryTrieSet> build() {
            return cidrs;
        }
    }
}

