package ru.yandex.util.ip;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CidrsMerger implements IpSet.Builder<List<Cidr>> {
    private final List<List<String>> cidrs = new ArrayList<>();

    @Override
    public void add(final String cidr) throws IOException {
        add(Cidr.fromString(cidr));
    }

    public void add(final Cidr cidr) {
        int len = cidr.addrLen();
        while (cidrs.size() <= len) {
            cidrs.add(null);
        }
        List<String> cidrs = this.cidrs.get(len);
        if (cidrs == null) {
            cidrs = new ArrayList<>();
            this.cidrs.set(len, cidrs);
        }
        cidrs.add(cidr.toBitString());
    }

    private static void merge(
        final int addrLen,
        final List<String> cidrs,
        final List<Cidr> merged)
    {
        cidrs.sort(Comparator.naturalOrder());
        for (int pos = cidrs.size() - 1; pos > 0; --pos) {
            String current = cidrs.get(pos);
            String prev = cidrs.get(pos - 1);
            if (current.equals(prev)) {
                cidrs.remove(pos);
            } else {
                int currentLen = current.length();
                int prevLen = prev.length();
                if (prevLen == currentLen) {
                    String shorten = current.substring(0, currentLen - 1);
                    if (prev.startsWith(shorten)) {
                        cidrs.remove(pos);
                        cidrs.set(pos - 1, shorten);
                        if (pos < cidrs.size()) {
                            // Try re-merge after folding something like this
                            // 0100
                            // 0101
                            // 011
                            ++pos;
                        }
                    }
                } else if (prevLen < currentLen && current.startsWith(prev)) {
                    cidrs.remove(pos);
                }
            }
        }
        for (String cidr: cidrs) {
            merged.add(Cidr.fromBitString(addrLen, cidr));
        }
    }

    @Override
    public List<Cidr> build() {
        List<Cidr> merged = new ArrayList<>();
        int size = cidrs.size();
        for (int i = 0; i < size; ++i) {
            List<String> cidrs = this.cidrs.get(i);
            if (cidrs != null) {
                merge(i, cidrs, merged);
            }
        }
        return merged;
    }

    public static void main(final String... args) throws IOException {
        List<Cidr> cidrs = IpSet.load(System.in, new CidrsMerger());
        int size = cidrs.size();
        for (int i = 0; i < size; ++i) {
            System.out.println(cidrs.get(i));
        }
    }
}

