package ru.yandex.util.ip;

import java.net.Inet6Address;
import java.net.InetAddress;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum HbfParser {
    INSTANCE;

    @Nullable
    public Long parseProjectId(@Nonnull InetAddress address) {
        final byte[] bytes = address.getAddress();
        if (!(address instanceof Inet6Address) || !hasHbfPrefix(bytes)) {
            return null;
        }
        long projectId = 0L;
        for (int i = 8; i < 12; ++i) {
            projectId <<= 8;
            projectId |= bytes[i] & 0xffL;
        }
        return projectId;
    }

    private static boolean hasHbfPrefix(final byte[] bytes) {
        // https://wiki.yandex-team.ru/NOC/newnetwork/hbf/projectid/
        if (bytes.length == 16
                && bytes[0] == 0x2a
                && bytes[1] == 0x02
                && bytes[2] == 0x06
                && bytes[3] == (byte) 0xb8) {
            byte b = bytes[4];
            if (b == 0x0c || b == (byte) 0xfc) {
                return true;
            }
        }
        return false;
    }
}
