package ru.yandex.util.ip;

import java.io.File;
import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableCidrListConfig
    implements CidrListConfig, ImmutableConfig, ReloadableIpCheckerFactory
{
    private final File file;

    public ImmutableCidrListConfig(final CidrListConfig config)
        throws ConfigException
    {
        file = FILE.validate(config.file());
    }

    @Override
    public File file() {
        return file;
    }

    @Override
    public ReloadableIpChecker createIpChecker() throws IOException {
        return new IpSetChecker<>(file, CidrSet.INSTANCE);
    }
}

