package ru.yandex.util.ip;

import java.io.File;
import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableIpListConfig
    implements IpListConfig, ImmutableConfig, ReloadableIpCheckerFactory
{
    private final File file;

    public ImmutableIpListConfig(final IpListConfig config)
        throws ConfigException
    {
        file = FILE.validate(config.file());
    }

    @Override
    public File file() {
        return file;
    }

    @Override
    public ReloadableIpChecker createIpChecker() throws IOException {
        return new IpSetChecker<>(file, IpHashSet.INSTANCE);
    }
}

