package ru.yandex.util.ip;

import java.io.File;
import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableIpRangeListConfig
    implements IpRangeListConfig, ImmutableConfig, ReloadableIpCheckerFactory
{
    private final File file;

    public ImmutableIpRangeListConfig(final IpRangeListConfig config)
        throws ConfigException
    {
        file = FILE.validate(config.file());
    }

    @Override
    public File file() {
        return file;
    }

    @Override
    public ReloadableIpChecker createIpChecker() throws IOException {
        return new IpSetChecker<>(file, IpRangeSet.INSTANCE);
    }
}

