package ru.yandex.util.ip;

import java.net.InetAddress;
import java.util.function.Function;

import com.google.common.net.InetAddresses;

public enum IpCompressor implements Function<InetAddress, String> {
    INSTANCE;

    @Override
    public String apply(final InetAddress ip) {
        return compress(ip);
    }

    public static String compress(final InetAddress ip) {
        return InetAddresses.toAddrString(ip);
    }
}

