package ru.yandex.util.ip;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;

public enum IpHashSet implements IpSet<Set<InetAddress>> {
    INSTANCE;

    @Override
    public Builder<Set<InetAddress>> createBuilder() {
        return new IpHashSetBuilder();
    }

    @Override
    public boolean contains(
        final Set<InetAddress> ips,
        final InetAddress ip)
    {
        return ips.contains(ip);
    }

    private static class IpHashSetBuilder
        implements Builder<Set<InetAddress>>
    {
        private final Set<InetAddress> ips = new HashSet<>();

        @Override
        public void add(final String ip) throws IOException {
            ips.add(InetAddress.getByName(ip));
        }

        @Override
        public Set<InetAddress> build() {
            return ips;
        }
    }
}

