package ru.yandex.util.ip;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class IpListConfigBuilder
    extends AbstractIpListConfigBuilder<IpListConfigBuilder>
{
    public IpListConfigBuilder() {
        super(IpListConfigDefaults.INSTANCE);
    }

    public IpListConfigBuilder(final IpListConfig config) {
        super(config);
    }

    public IpListConfigBuilder(final IniConfig config) throws ConfigException {
        this(config, IpListConfigDefaults.INSTANCE);
    }

    public IpListConfigBuilder(
        final IniConfig config,
        final IpListConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public IpListConfigBuilder self() {
        return this;
    }

    public ImmutableIpListConfig build() throws ConfigException {
        return new ImmutableIpListConfig(this);
    }
}

