package ru.yandex.util.ip;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class IpRangeListConfigBuilder
    extends AbstractIpRangeListConfigBuilder<IpRangeListConfigBuilder>
{
    public IpRangeListConfigBuilder() {
        super(IpRangeListConfigDefaults.INSTANCE);
    }

    public IpRangeListConfigBuilder(final IpRangeListConfig config) {
        super(config);
    }

    public IpRangeListConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, IpRangeListConfigDefaults.INSTANCE);
    }

    public IpRangeListConfigBuilder(
        final IniConfig config,
        final IpRangeListConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public IpRangeListConfigBuilder self() {
        return this;
    }

    public ImmutableIpRangeListConfig build() throws ConfigException {
        return new ImmutableIpRangeListConfig(this);
    }
}

