package ru.yandex.util.ip;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;

import ru.yandex.util.string.StringUtils;

public class IpSetChecker<T> implements ReloadableIpChecker {
    private final File file;
    private final IpSet<T> ipSet;
    private final String name;
    private volatile T ips;
    private long lastModified = 0L;

    public IpSetChecker(
        final File file,
        final IpSet<T> ipSet)
        throws IOException
    {
        this.file = file;
        this.ipSet = ipSet;
        String ipSetName = ipSet.getClass().getSimpleName();
        String fileName = file.toString();
        name = StringUtils.concat(ipSetName, '(', fileName, ')');
        reload();
    }

    @Override
    public void reload() throws IOException {
        long lastModified;
        synchronized (this) {
            lastModified = file.lastModified();
            if (this.lastModified == lastModified) {
                return;
            }
        }
        ips = ipSet.load(file);
        synchronized (this) {
            this.lastModified = lastModified;
        }
    }

    @Override
    public boolean test(final InetAddress ip) {
        return ipSet.contains(ips, ip);
    }

    @Override
    public String toString() {
        return name;
    }
}

