package ru.yandex.jni.catboost;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import ru.yandex.function.GenericAutoCloseable;

public class JniCatboostFeatures implements GenericAutoCloseable<RuntimeException> {
    static {
        System.loadLibrary("jni-catboost");
    }

    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = lock.readLock();
    private final Lock writeLock = lock.writeLock();
    private long handle;

    long handle() {
        return handle;
    }

    Lock readLock() {
        return readLock;
    }

    public JniCatboostFeatures() throws JniCatboostException {
        try {
            handle = createInstance();
        } catch (RuntimeException e) {
            throw new JniCatboostException("Failed to create instance", e);
        }
    }

    @SuppressWarnings("UnsafeFinalization")
    public void setNumericFeature(String feature, float value) throws JniCatboostException {
        readLock.lock();
        try {
            if (handle == 0L) {
                throw new JniCatboostException("Features already closed");
            }
            setNumericFeature(handle, feature, value);
        } catch (RuntimeException e) {
            throw new JniCatboostException("Failed to create instance", e);
        } finally {
            readLock.unlock();
        }
    }

    @SuppressWarnings("UnsafeFinalization")
    public void setCategoricalFeature(String feature, String value) throws JniCatboostException {
        readLock.lock();
        try {
            if (handle == 0L) {
                throw new JniCatboostException("Features already closed");
            }
            setCategoricalFeature(handle, feature, value);
        } catch (RuntimeException e) {
            throw new JniCatboostException("Failed to create instance", e);
        } finally {
            readLock.unlock();
        }
    }

    @Override
    public void close() {
        writeLock.lock();
        try {
            if (handle != 0L) {
                long handle = this.handle;
                this.handle = 0L;
                destroyInstance(handle);
            }
        } finally {
            writeLock.unlock();
        }
    }

    @Override
    @SuppressWarnings("deprecation")
    protected void finalize() {
        close();
    }

    private static native long createInstance();

    private static native void destroyInstance(final long handle);

    private static native void setNumericFeature(final long handle, final String feature, float value);

    private static native void setCategoricalFeature(final long handle, final String feature, String value);
}
