package ru.yandex.jni.catboost;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import ru.yandex.function.GenericAutoCloseable;

public class JniCatboostModel implements GenericAutoCloseable<RuntimeException> {
    static {
        System.loadLibrary("jni-catboost");
    }

    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = lock.readLock();
    private final Lock writeLock = lock.writeLock();
    private long handle;

    public JniCatboostModel(File pathToModel, File pathToDict) throws JniCatboostException {
        try {
            handle = createInstance(pathToModel.getPath(), pathToDict.getPath());
        } catch (RuntimeException e) {
            throw new JniCatboostException("Failed to create instance", e);
        }
    }

    @SuppressWarnings("UnsafeFinalization")
    public double[] calc(JniCatboostFeatures features) throws JniCatboostException {
        readLock.lock();
        features.readLock().lock();
        try {
            if (handle == 0L) {
                throw new JniCatboostException("Features already closed");
            }
            return calc(handle, features.handle());
        } catch (RuntimeException e) {
            throw new JniCatboostException("Failed to calc features", e);
        } finally {
            readLock.unlock();
            features.readLock().unlock();
        }
    }

    @Override
    public void close() {
        writeLock.lock();
        try {
            if (handle != 0L) {
                long handle = this.handle;
                this.handle = 0L;
                destroyInstance(handle);
            }
        } finally {
            writeLock.unlock();
        }
    }

    @Override
    @SuppressWarnings("deprecation")
    protected void finalize() {
        close();
    }

    private static native long createInstance(String pathToModel, String pathToDict);

    private static native void destroyInstance(final long handle);

    private static native double[] calc(final long modelHandle, final long featuresHandle);
}

