#include <mail/so/libs/jniwrapper_base/jniwrapper_base.h>

extern "C" JNIEXPORT jint JNICALL
Java_ru_yandex_jni_digest_JniDigest_commonHashes(
    JNIEnv *env,
    jclass,
    jintArray hashes1,
    jintArray hashes2)
{
    try {
        NJniWrapper::TCriticalArrayElements<int> a1{env, hashes1, JNI_ABORT};
        NJniWrapper::TCriticalArrayElements<int> a2{env, hashes2, JNI_ABORT};
        int result = 0;
        const int* p1 = a1.GetData();
        const int* p2 = a2.GetData();
        const int* p1End = p1 + a1.GetSize();
        const int* p2End = p2 + a2.GetSize();
        while (p1 < p1End && p2 < p2End) {
            if (*p1 == *p2) {
                ++p1;
                ++p2;
                ++result;
            } else if (*p1 < *p2) {
                ++p1;
            } else {
                ++p2;
            }
        }
        return result;
    } catch (...) {
        NJniWrapper::RethrowAsJavaException(env);
        return 0;
    }
}

