package ru.yandex.jni.hypocrisy;

import javax.annotation.Nullable;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;

public class JniHypocrisy {
    static {
        System.loadLibrary("jni-hypocrisy");
    }

    @Nullable
    public static JsonObject decode(byte[] key, String encodedData) throws JniHypocrisyException, JsonException {
        @Nullable final String decoded;
        try {
            decoded = decodeImpl(key, encodedData);
        } catch (RuntimeException e) {
            throw new JniHypocrisyException(e);
        }

        if (decoded != null) {
            return TypesafeValueContentHandler.parse(decoded);
        } else {
            return null;
        }

    }

    private static native String decodeImpl(byte[] key, String encodedData);
}

