#include <mail/so/libs/jniwrapper_base/jniwrapper_base.h>

#include <jni.h>
#include <library/cpp/json/json_writer.h>
#include <library/cpp/string_utils/base64/base64.h>
#include <antirobot/lib/hypocrisy/hypocrisy.h>
#include <util/generic/scope.h>


extern "C" JNIEXPORT jstring JNICALL
Java_ru_yandex_jni_hypocrisy_JniHypocrisy_decodeImpl(
        JNIEnv *env,
        jclass,
        jbyteArray key,
        jstring encryptedData) noexcept {
    try {
        jbyte * keyArray = env->GetByteArrayElements(key, nullptr);
        const TMaybe<NHypocrisy::TFingerprintData> data = NHypocrisy::TFingerprintData::Decrypt(
                TStringBuf((char *) keyArray, env->GetArrayLength(key)),
                NJniWrapper::JStringToUtf(env, encryptedData));
        Y_DEFER{
            env->ReleaseByteArrayElements(key, keyArray, 0);
        };


        if (data) {

            NJsonWriter::TBuf buf;

            buf.BeginObject();

            for (const auto&[k, v]: data->Fingerprint.GetMap()) {
                buf.WriteKey(k);
                buf.WriteString(v.GetStringRobust());
            }

            buf.EndObject();
            return NJniWrapper::UtfToJString(env, buf.Str().c_str());
        } else {
            return nullptr;
        }
    } catch (...) {
        NJniWrapper::RethrowAsJavaException(env);
        return nullptr;
    }
}

