package ru.yandex.jni.pcre;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import ru.yandex.function.GenericAutoCloseable;

public class JniPcre implements GenericAutoCloseable<RuntimeException> {
    static {
        System.loadLibrary("jni-pcre");
    }

    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = lock.readLock();
    private final Lock writeLock = lock.writeLock();
    private long handle;

    public JniPcre(final boolean useHyperscan) throws JniPcreException {
        try {
            handle = createInstance(useHyperscan);
        } catch (RuntimeException e) {
            throw new JniPcreException("Failed to create instance", e);
        }
    }

    @SuppressWarnings("UnsafeFinalization")
    public int addRegex(final String regex) throws JniPcreException {
        readLock.lock();
        try {
            if (handle == 0L) {
                throw new JniPcreException("JniPcre already closed");
            }
            return addRegex(handle, regex);
        } catch (RuntimeException e) {
            throw new JniPcreException(
                "Failed to add regex '" + regex + '\'',
                e);
        } finally {
            readLock.unlock();
        }
    }

    @SuppressWarnings("UnsafeFinalization")
    public int findMatch(final String str) throws JniPcreException {
        readLock.lock();
        try {
            if (handle == 0L) {
                return -1;
            }
            return findMatch(handle, str);
        } catch (RuntimeException e) {
            throw new JniPcreException("Match failed", e);
        } finally {
            readLock.unlock();
        }
    }

    @Override
    public void close() {
        writeLock.lock();
        try {
            if (handle != 0L) {
                long handle = this.handle;
                this.handle = 0L;
                destroyInstance(handle);
            }
        } finally {
            writeLock.unlock();
        }
    }

    @Override
    @SuppressWarnings("deprecation")
    protected void finalize() {
        close();
    }

    private static native long createInstance(final boolean useHyperscan);

    private static native void destroyInstance(final long handle);

    private static native int addRegex(final long handle, final String regex);

    private static native int findMatch(final long handle, final String regex);
}

