#include <dlfcn.h>
#include <stdio.h>
#include <unistd.h>

#define IOV_MAX_OVERRIDE 4

static long (*sysconfOrig)(int name);

void init(void) {
    sysconfOrig = dlsym(RTLD_NEXT, "sysconf");
}

//override IOV_MAX called from Java_sun_nio_ch_IOUtil_iovMax
//on ibm jre, to prevent DirectByteBuffer overallocation
__attribute__((__visibility__("default")))
long sysconf(int name) {
    if (name == _SC_IOV_MAX) {
        fprintf(stderr, "Overriding IOV_MAX to %d\n", IOV_MAX_OVERRIDE);
        return IOV_MAX_OVERRIDE;
    } else {
        if (sysconfOrig == NULL) {
            init();
        }
        return sysconfOrig(name);
    }
}

