package ru.yandex.detect.locale;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public class LocaleTables {
    private static final int INITIAL_LOCALES_CAPACITY = 8;
    private static final int[] EMPTY_TABLE = new int[0];

    private Locale[] locales = new Locale[INITIAL_LOCALES_CAPACITY];
    private int localesCount = 0;
    private int[] charTable = EMPTY_TABLE;

    public int localesCount() {
        return localesCount;
    }

    public Locale locale(final int id) {
        if (id >= localesCount) {
            return null;
        } else {
            return locales[id];
        }
    }

    public int charToLocaleMask(final char c) {
        if (c >= charTable.length) {
            return 0;
        } else {
            return charTable[c];
        }
    }

    public void addLocale(final Locale locale, final String alphabet) {
        Objects.requireNonNull(locale);
        int id = localesCount++;
        if (localesCount > locales.length) {
            locales = Arrays.copyOf(locales, localesCount << 1);
        }
        locales[id] = locale;
        int mask = 1 << id;
        char[] chars = alphabet.toCharArray();
        char max = 0;
        for (char c: chars) {
            if (c > max) {
                max = c;
            }
        }
        if (max > charTable.length) {
            charTable = Arrays.copyOf(
                charTable,
                Math.max(max + 1, charTable.length << 1));
        }
        for (char c: chars) {
            charTable[c] |= mask;
        }
    }
}

