package ru.yandex.util.match.tables;

public class MatchTables {
    private MatchTables() {
    }

    public static boolean[] createMatchTable(final String s) {
        int max = s.chars().max().getAsInt();
        boolean[] table = new boolean[max + 1];
        for (char c: s.toCharArray()) {
            table[c] = true;
        }
        return table;
    }

    public static boolean[] mergeMatchTables(final boolean[]... tables) {
        int max = tables[0].length;
        for (int i = 1; i < tables.length; ++i) {
            max = Math.max(max, tables[i].length);
        }
        boolean[] result = new boolean[max];
        for (boolean[] table: tables) {
            for (int i = 0; i < table.length; ++i) {
                if (table[i]) {
                    result[i] = true;
                }
            }
        }
        return result;
    }

    public static boolean match(final boolean[] table, final char c) {
        return c < table.length && table[c];
    }
}

