package ru.yandex.matrixnet;

import java.io.File;
import java.io.InputStream;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractMatrixnetModelConfigBuilder<T
    extends AbstractMatrixnetModelConfigBuilder<T>>
    implements MatrixnetModelConfig
{
    public static final String NAME = "name";
    public static final String MODEL_FILE = "model-file";

    private InputStream content;
    private File file;
    private String name;

    protected AbstractMatrixnetModelConfigBuilder(
        final MatrixnetModelConfig config)
    {
        content(config.content());
        file(config.file());
        name(config.name());
    }

    protected AbstractMatrixnetModelConfigBuilder(
        final IniConfig config,
        final MatrixnetModelConfig defaults)
        throws ConfigException
    {
        this.content = null;
        this.file = config.getInputFile(MODEL_FILE, defaults.file());
        this.name = config.getString(NAME, defaults.name());
    }

    public T content(final InputStream content) {
        this.content = content;

        if (content != null) {
            this.file = null;
        }

        return self();
    }

    @Override
    public InputStream content() {
        return content;
    }

    public T file(final File file) {
        this.file = file;
        if (file != null) {
            this.content = null;
        }

        return self();
    }

    @Override
    public File file() {
        return file;
    }

    protected abstract T self();

    public T name(final String name) {
        this.name = name;
        return self();
    }

    @Override
    public String name() {
        return name;
    }
}
