package ru.yandex.matrixnet;

import java.io.File;
import java.io.InputStream;

import ru.yandex.matrixnet.BasicMatrixnetModel.MatrixnetModelParseException;
import ru.yandex.parser.config.ConfigException;

public class ImmutableMatrixnetModelConfig implements MatrixnetModelConfig {
    private final File file;
    private final InputStream content;
    private final String name;

    protected ImmutableMatrixnetModelConfig() {
        this.file = null;
        this.content = null;
        this.name = "default";
    }

    public ImmutableMatrixnetModelConfig(final MatrixnetModelConfig config)
        throws ConfigException
    {
        this.file = config.file();
        this.content = config.content();
        this.name = config.name();

        if (file == null && content == null) {
            throw new ConfigException("file and content fields both empty");
        }
    }

    @Override
    public File file() {
        return file;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public InputStream content() {
        return content;
    }

    public BasicMatrixnetModel buildModel() throws ConfigException {
        try {
            return new BasicMatrixnetModel(this);
        } catch (MatrixnetModelParseException pe) {
            throw new ConfigException("Can not buildModel matrixnet model", pe);
        }
    }
}
