package ru.yandex.mail.mime;

import org.apache.james.mime4j.stream.BodyDescriptor;

public class BasicBodyDescriptor implements BodyDescriptor {
    private final String mimeType;
    private final String mediaType;
    private final String subType;
    private final String boundary;
    private final String charset;
    private final String transferEncoding;
    private final long contentLength;

    BasicBodyDescriptor(
        final String mimeType,
        final String mediaType,
        final String subType,
        final String boundary,
        final String charset,
        final String transferEncoding,
        final long contentLength)
    {
        this.mimeType = mimeType;
        this.mediaType = mediaType;
        this.subType = subType;
        this.boundary = boundary;
        this.charset = charset;
        this.transferEncoding = transferEncoding;
        this.contentLength = contentLength;
    }

    @Override
    public String getMimeType() {
        return mimeType;
    }

    @Override
    public String getMediaType() {
        return mediaType;
    }

    @Override
    public String getSubType() {
        return subType;
    }

    @Override
    public String getBoundary() {
        return boundary;
    }

    @Override
    public String getCharset() {
        return charset;
    }

    @Override
    public String getTransferEncoding() {
        return transferEncoding;
    }

    @Override
    public long getContentLength() {
        return contentLength;
    }
}

