package ru.yandex.mail.mime;

import java.io.InputStream;
import java.util.function.BiFunction;

import org.apache.james.mime4j.util.MimeUtil;

import ru.yandex.base64.Base64InputStream;
import ru.yandex.io.LenientQuotedPrintableInputStream;

public enum BodyDecoder
    implements BiFunction<InputStream, String, InputStream>
{
    INSTANCE;

    @Override
    public InputStream apply(
        final InputStream in,
        final String transferEncoding)
    {
        if (MimeUtil.isBase64Encoding(transferEncoding)) {
            return new Base64InputStream(in);
        } else if (MimeUtil.isQuotedPrintableEncoded(transferEncoding)) {
            return new LenientQuotedPrintableInputStream(in);
        } else {
            return in;
        }
    }
}

