package ru.yandex.parser.rfc2047;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;

import ru.yandex.base64.Base64Decoder;
import ru.yandex.charset.Decoder;
import ru.yandex.function.StringVoidProcessor;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.io.QuotedPrintableDecoder;

public enum DefaultRfc2047DecodersProvider implements Rfc2047DecodersProvider {
    INSTANCE;

    @Override
    public StringBuilder stringBuilder(int expectedLength) {
        return new StringBuilder(expectedLength);
    }

    @Override
    public DecodableByteArrayOutputStream byteArray(int expectedLength) {
        return new DecodableByteArrayOutputStream(expectedLength);
    }

    @Override
    public Decoder decoderFor(final Charset charset) {
        return new Decoder(charset, CodingErrorAction.REPLACE);
    }

    @Override
    public StringVoidProcessor<byte[], IOException> base64Decoder() {
        return new StringVoidProcessor<>(new Base64Decoder());
    }

    @Override
    public StringVoidProcessor<byte[], IOException> quotedPrintableDecoder() {
        return new StringVoidProcessor<>(new QuotedPrintableDecoder());
    }
}

