package ru.yandex.parser.rfc2047;

import java.io.IOException;
import java.nio.charset.Charset;

import ru.yandex.charset.Decoder;
import ru.yandex.function.StringVoidProcessor;
import ru.yandex.io.DecodableByteArrayOutputStream;

public interface Rfc2047DecodersProvider {
    StringBuilder stringBuilder(int expectedLength);

    DecodableByteArrayOutputStream byteArray(int expectedLength);

    Decoder decoderFor(Charset charset);

    StringVoidProcessor<byte[], IOException> base64Decoder();

    StringVoidProcessor<byte[], IOException> quotedPrintableDecoder();
}

