package ru.yandex.parser.string;

import java.util.Map;

import ru.yandex.function.GenericFunction;

public enum AliasParser
    implements GenericFunction<
        String,
        Map.Entry<String, String>,
        IllegalArgumentException>
{
    INSTANCE;

    @Override
    public Map.Entry<String, String> apply(final String value) {
        String str = value.trim();
        int len = str.length();
        if (len == 0) {
            throw new IllegalArgumentException("Empty values not allowed");
        }

        String name;
        String alias;
        if (str.charAt(len - 1) == ')') {
            int idx = str.indexOf('(');
            if (idx == -1) {
                throw new IllegalArgumentException(
                    "Invalid value <" + value + '>');
            }
            name = str.substring(0, idx).trim();
            if (name.isEmpty()) {
                throw new IllegalArgumentException(
                    "Empty name in value <" + value + '>');
            }
            alias = str.substring(idx + 1, len -1).trim();
            if (alias.isEmpty()) {
                throw new IllegalArgumentException(
                    "Empty alias in value <" + value + '>');
            }
        } else {
            name = str;
            alias = str;
        }
        return Map.entry(name, alias);
    }
}

