package ru.yandex.parser.string;

import ru.yandex.function.GenericFunction;

public enum BooleanParser
    implements GenericFunction<String, Boolean, RuntimeException>
{
    INSTANCE;

    @Override
    public Boolean apply(final String value) {
        switch (value.trim()) {
            case "true":
            case "True":
            case "yes":
            case "Yes":
            case "on":
            case "On":
            case "да":
            case "Да":
            case "1":
                return Boolean.TRUE;

            case "false":
            case "False":
            case "no":
            case "No":
            case "off":
            case "Off":
            case "нет":
            case "Нет":
            case "0":
                return Boolean.FALSE;

            default:
                throw new IllegalArgumentException("Bad boolean: " + value);
        }
    }
}
