package ru.yandex.parser.string;

import java.util.Collection;
import java.util.function.Supplier;

import ru.yandex.function.BasicGenericCollector;
import ru.yandex.function.GenericBiConsumer;
import ru.yandex.function.GenericFunction;

public class CollectionParser<T, C extends Collection<T>, E extends Exception>
    extends SplittingParser<C, C, E>
{
    public CollectionParser(
        final GenericFunction<String, ? extends T, E> parser,
        final Supplier<? extends C> collectionSupplier)
    {
        this(parser, collectionSupplier, ',');
    }

    public CollectionParser(
        final GenericFunction<String, ? extends T, E> parser,
        final Supplier<? extends C> collectionSupplier,
        final char delimiter)
    {
        this(
            collectionSupplier,
            (collection, sb) -> collection.add(parser.apply(sb.toString())),
            delimiter);
    }

    public CollectionParser(
        final Supplier<? extends C> supplier,
        final GenericBiConsumer<? super C, ? super StringBuilder, ? extends E>
        accumulator,
        final char delimiter)
    {
        super(BasicGenericCollector.of(supplier, accumulator), delimiter);
    }
}

