package ru.yandex.parser.string;

import java.util.Collection;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.GenericUnaryOperator;

public class CollectionValidator<T, C extends Collection<T>>
    implements GenericUnaryOperator<C, Exception>
{
    private final GenericFunction<? super T, ?, ? extends Exception> validator;

    public CollectionValidator(
        final GenericFunction<? super T, ?, ? extends Exception> validator)
    {
        this.validator = validator;
    }

    @Override
    public C apply(final C value) throws Exception {
        for (T t: value) {
            validator.apply(t);
        }
        return value;
    }
}

