package ru.yandex.parser.string;

import java.io.File;

import ru.yandex.function.GenericUnaryOperator;

public enum DirectoryValidator
    implements GenericUnaryOperator<File, Exception>
{
    INSTANCE;

    @Override
    public File apply(final File dir) throws Exception {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(dir + " not a directory");
            }
            if (!dir.canWrite()) {
                throw new IllegalArgumentException("Can't write to directory "
                    + dir);
            }
        } else {
            apply(dir.getAbsoluteFile().getParentFile());
        }
        return dir;
    }
}

