package ru.yandex.parser.string;

import ru.yandex.function.GenericFunction;

public enum DoubleToIntegerValidator
    implements GenericFunction<Double, Integer, RuntimeException>
{
    INSTANCE;

    @Override
    public Integer apply(final Double value) {
        int result = value.intValue();
        if (result != value.doubleValue()) {
            throw new IllegalArgumentException("Overflow occured");
        }
        return result;
    }
}

