package ru.yandex.parser.string;

import ru.yandex.function.GenericFunction;

public enum DoubleToLongValidator
    implements GenericFunction<Double, Long, RuntimeException>
{
    INSTANCE;

    @Override
    public Long apply(final Double value) {
        long result = value.longValue();
        if (result != value.doubleValue()) {
            throw new IllegalArgumentException("Overflow occured");
        }
        return result;
    }
}

