package ru.yandex.parser.string;

import java.util.Locale;

import ru.yandex.function.GenericFunction;

public class EnumParser<E extends Enum<E>>
    implements GenericFunction<String, E, RuntimeException>
{
    private final Class<E> e;

    public EnumParser(final Class<E> e) {
        this.e = e;
    }

    @Override
    public E apply(final String value) {
        return Enum.valueOf(
            e,
            value.trim().toUpperCase(Locale.ROOT).replace('-', '_'));
    }
}

