package ru.yandex.parser.string;

import java.io.File;

import ru.yandex.function.GenericUnaryOperator;

public enum ExistingDirectoryValidator
    implements GenericUnaryOperator<File, Exception>
{
    INSTANCE;

    @Override
    public File apply(final File dir) throws Exception {
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory " + dir
                + " doesn't exist");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " not a directory");
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Can't write to directory "
                + dir);
        }
        return dir;
    }
}

