package ru.yandex.parser.string;

import java.io.File;

import ru.yandex.function.GenericFunction;

public enum FileParser implements GenericFunction<String, File, Exception> {
    INSTANCE;

    public static final GenericFunction<String, File, Exception> INPUT_FILE =
        INSTANCE.andThen(InputFileValidator.INSTANCE);
    public static final GenericFunction<String, File, Exception> OUTPUT_FILE =
        INSTANCE.andThen(OutputFileValidator.INSTANCE);
    public static final GenericFunction<String, File, Exception> DIRECTORY =
        INSTANCE.andThen(DirectoryValidator.INSTANCE);
    public static final GenericFunction<String, File, Exception>
        EXISTING_DIRECTORY =
            INSTANCE.andThen(ExistingDirectoryValidator.INSTANCE);

    @Override
    public File apply(final String value) throws Exception {
        return new File(value);
    }
}
