package ru.yandex.parser.string;

import ru.yandex.function.GenericFunction;

public enum FiniteNumberValidator
    implements GenericFunction<Number, Number, Exception>
{
    INSTANCE;

    @Override
    public Number apply(final Number value) throws Exception {
        if (Double.isFinite(value.doubleValue())) {
            return value;
        } else {
            throw new IllegalArgumentException(
                "Value " + value + " is not a finite value");
        }
    }

    @SuppressWarnings("unchecked")
    public static <T extends Number, E extends Exception>
        GenericFunction<T, T, E> instance()
    {
        return (GenericFunction<T, T, E>) INSTANCE;
    }
}

