package ru.yandex.parser.string;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.collection.HostnamePredicate;
import ru.yandex.function.GenericFunction;

public enum HostnamePredicateParser
    implements GenericFunction<String, HostnamePredicate, Exception>
{
    INSTANCE;

    private static final CollectionParser<String, List<String>, Exception>
        PARSER = new CollectionParser<>(
            NonEmptyValidator.TRIMMED,
            ArrayList::new);

    @Override
    public HostnamePredicate apply(final String value) throws Exception {
        return HostnamePredicate.create(PARSER.apply(value));
    }
}

