package ru.yandex.parser.string;

import java.io.File;

import ru.yandex.function.GenericUnaryOperator;

public enum InputFileValidator
    implements GenericUnaryOperator<File, Exception>
{
    INSTANCE;

    private static final String FILE = "File ";

    @Override
    public File apply(final File file) throws Exception {
        if (!file.exists()) {
            throw new IllegalArgumentException(FILE + file + " doesn't exist");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " not a regular file");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(FILE + file
                + " cannot be open for reading");
        }
        return file;
    }
}

