package ru.yandex.parser.string;

import java.nio.file.Files;
import java.nio.file.Path;

import ru.yandex.function.GenericUnaryOperator;

public enum InputPathDirectoryValidator
    implements GenericUnaryOperator<Path, Exception>
{
    INSTANCE;

    @Override
    public Path apply(final Path dir) throws Exception {
        if (!Files.isDirectory(dir)) {
            throw new IllegalArgumentException(dir + " not a directory");
        }
        return dir;
    }
}

