package ru.yandex.parser.string;

import ru.yandex.collection.IntInterval;

public class IntIntervalParser implements Parser<IntInterval> {
    public static final IntIntervalParser INSTANCE = new IntIntervalParser();

    protected IntIntervalParser() {
    }

    @Override
    public IntInterval parse(final String value) {
        int idx = value.indexOf('-');
        int begin;
        int end;
        if (idx == -1) {
            begin = Integer.parseInt(value);
            end = begin;
        } else {
            begin = Integer.parseInt(value.substring(0, idx).trim());
            end = Integer.parseInt(value.substring(idx + 1).trim());
        }
        return new IntInterval(begin, end);
    }
}

