package ru.yandex.parser.string;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.collection.IntInterval;
import ru.yandex.collection.IntIntervalSet;
import ru.yandex.collection.IntSet;
import ru.yandex.function.StringProcessor;

public class IntSetParser implements Parser<IntSet> {
    public static final IntSetParser INSTANCE = new IntSetParser();

    private final CollectionParser<IntInterval, List<IntInterval>, Exception>
        parser;

    protected IntSetParser() {
        this(',');
    }

    public IntSetParser(final char delimiter) {
        this(delimiter, false);
    }

    public IntSetParser(final char delimiter, final boolean strict) {
        Parser<IntInterval> parser;
        if (strict) {
            parser = StrictIntIntervalParser.INSTANCE;
        } else {
            parser = IntIntervalParser.INSTANCE;
        }
        this.parser =
            new CollectionParser<>(parser, ArrayList::new, delimiter);
    }

    @Override
    public IntSet parse(final String value) throws Exception {
        return IntIntervalSet.create(
            new StringProcessor<>(parser).process(value));
    }
}

