package ru.yandex.parser.string;

public class IntegerMemorySizeParser extends MemorySizeParser<Integer> {
    public static final IntegerMemorySizeParser INSTANCE =
        new IntegerMemorySizeParser();
    public static final IntegerMemorySizeParser POSITIVE =
        new IntegerMemorySizeParser(PositiveIntegerValidator.INSTANCE);

    protected IntegerMemorySizeParser() {
        this(NonNegativeIntegerValidator.INSTANCE);
    }

    public IntegerMemorySizeParser(final Parser<Integer> parser) {
        super(parser);
    }

    @Override
    protected Integer fromDouble(final double value) {
        return (int) value;
    }
}

