package ru.yandex.parser.string;

public class LongMemorySizeParser extends MemorySizeParser<Long> {
    public static final LongMemorySizeParser INSTANCE =
        new LongMemorySizeParser();

    public static final LongMemorySizeParser POSITIVE =
        new LongMemorySizeParser(PositiveLongValidator.INSTANCE);

    protected LongMemorySizeParser() {
        this(NonNegativeLongValidator.INSTANCE);
    }

    private LongMemorySizeParser(final Parser<Long> parser) {
        super(parser);
    }

    @Override
    protected Long fromDouble(final double value) {
        return (long) value;
    }
}

