package ru.yandex.parser.string;

public abstract class MemorySizeParser<T extends Number> implements Parser<T> {
    private static final int NONE = 0;
    private static final int KILOS = 1;
    private static final int MEGAS = 2;
    private static final int GIGAS = 3;

    private static final double[] MULTIPLIERS = new double[] {
        1d,
        1024d,
        1048576d,
        1073741824d
    };

    private final Parser<? extends T> parser;

    protected MemorySizeParser(final Parser<? extends T> parser) {
        this.parser = parser;
    }

    protected abstract T fromDouble(final double value);

    @Override
    public T parse(final String value) throws Exception {
        int end = value.length() - 1;
        char last = value.charAt(end);
        int type;
        switch (last) {
            case 'k':
            case 'K':
                type = KILOS;
                break;
            case 'm':
            case 'M':
                type = MEGAS;
                break;
            case 'g':
            case 'G':
                type = GIGAS;
                break;
            default:
                type = NONE;
                break;
        }
        if (type == NONE && value.indexOf('.') == -1) {
            return parser.parse(value);
        } else {
            double multiplier = MULTIPLIERS[type];
            if (value.charAt(end - 1) == ' ') {
                --end;
            }
            double doubleSize = Math.ceil(
                Double.parseDouble(value.substring(0, end)) * multiplier);
            if (doubleSize < 0) {
                throw new IllegalArgumentException(
                    "Non negative value expected");
            }
            T size = fromDouble(doubleSize);
            if (size.doubleValue() != doubleSize) {
                throw new IllegalArgumentException("Overflow occured");
            }
            return size;
        }
    }
}

