package ru.yandex.parser.string;

import java.util.Collection;

import ru.yandex.function.GenericUnaryOperator;

public enum NonEmptyCollectionValidator
    implements GenericUnaryOperator<Collection<?>, Exception>
{
    INSTANCE;

    @Override
    public Collection<?> apply(final Collection<?> value) throws Exception {
        if (value.isEmpty()) {
            throw new IllegalArgumentException(
                "Value must contains at least one element");
        }
        return value;
    }

    @SuppressWarnings("unchecked")
    public static <T, C extends Collection<? extends T>>
        GenericUnaryOperator<C, Exception> instance()
    {
        return (GenericUnaryOperator<C, Exception>) INSTANCE;
    }
}

