package ru.yandex.parser.string;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.GenericUnaryOperator;

public enum NonEmptyValidator
    implements GenericUnaryOperator<String, Exception>
{
    INSTANCE;

    public static final GenericFunction<String, String, Exception> TRIMMED =
        INSTANCE.compose(String::trim);

    @Override
    public String apply(final String value) throws Exception {
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Value must be non-empty");
        }
        return value;
    }
}

