package ru.yandex.parser.string;

public class NonNegativeIntegerValidator extends Validator<Integer> {
    public static final NonNegativeIntegerValidator INSTANCE =
        new NonNegativeIntegerValidator();

    protected NonNegativeIntegerValidator() {
        super(IntegerParser.INSTANCE);
    }

    @Override
    public void validate(final Integer value) throws Exception {
        if (value < 0) {
            throw new IllegalArgumentException("Value must be non negative");
        }
    }
}

