package ru.yandex.parser.string;

public class NonNegativeLongValidator extends Validator<Long> {
    public static final NonNegativeLongValidator INSTANCE =
        new NonNegativeLongValidator(LongParser.INSTANCE);

    public NonNegativeLongValidator(final Parser<Long> parser) {
        super(parser);
    }

    @Override
    public void validate(final Long value) throws Exception {
        if (value < 0L) {
            throw new IllegalArgumentException("Value must be non negative");
        }
    }
}

