package ru.yandex.parser.string;

public class NotLessDoubleValidator extends Validator<Double> {
    private final double min;

    public NotLessDoubleValidator(final double min) {
        super(DoubleParser.INSTANCE);
        this.min = min;
    }

    @Override
    public void validate(final Double value) throws Exception {
        if (value < min) {
            throw new IllegalArgumentException("Value must be not less than "
                + min);
        }
    }
}

